//-----------------------------------------------------------------
// SX15-Evo Firmware di test con SX13
// Data : 25-01-06
// Versione : 1.0
// Area SX
// http://www.areasx.com
// Note     : per utilizzare il firmware collegare il connettore JP4
// della scheda SX15E al connettore della scheda SX13
// ed impostare su ON i ponticelli 5 e 7 del DIP S3
//
//-----------------------------------------------------------------
//-----------------------------------------------------------------

//-----------------------------------------------------------------
// Configurazione Firmware
//-----------------------------------------------------------------


//-----------------------------------------------------------------
// Define Hardware
//-----------------------------------------------------------------
#define LEDLD1_ON       BitWrPortI(PFDR,&PFDRShadow,1,1)
#define LEDLD1_OFF      BitWrPortI(PFDR,&PFDRShadow,0,1)
#define LEDLD2_ON       BitWrPortI(PFDR,&PFDRShadow,1,0)
#define LEDLD2_OFF      BitWrPortI(PFDR,&PFDRShadow,0,0)
#define LEDLD3_ON       BitWrPortI(PFDR,&PFDRShadow,1,4)
#define LEDLD3_OFF      BitWrPortI(PFDR,&PFDRShadow,0,4)

#define KEY_PRESSED   BitRdPortI(PEDR,1)


#define BINBUFSIZE    511
#define BOUTBUFSIZE   511

#define SET_ADDRESS 0x53  //Comando S. Impostazione indirizzo
#define SET_DIMMER  0x4C  //Comando L. Impostazione dimmer


//-----------------------------------------------------------------
// Globali
//-----------------------------------------------------------------
char rxBuff[512];
char txBuff[512];
char tmpbuf[500];
int nchar;
int i;

//-----------------------------------------------------------------
// Prototipi
//-----------------------------------------------------------------
void BoardInit(void);
void msDelay(unsigned int);
void SendDimCommand(char, char, char);


//--------------------------------------------------------
// Ritardo bloccante
// Riceve      : ams - numero di millisecondi da ritardare
// Restituisce : -
// Note        :
//--------------------------------------------------------
nodebug
void msDelay(unsigned int ams)
{
  auto unsigned long t0;
  for(t0=MS_TIMER; MS_TIMER<ams+t0;);
}

//--------------------------------------------------------
// Inizializza i port del modulo RCM
// Riceve      : -
// Restituisce : -
// Note        :
//--------------------------------------------------------
void BoardInit() {

  // Port A
  // Default ingresso

  // Port B
  // PB0 - ICL (output)
  BitWrPortI(PBDDR,&PBDDRShadow,1,0);
  // PB2 - IDA (input)
  // PB3 - IPL (output)
  BitWrPortI(PBDDR,&PBDDRShadow,1,3);
  // PB4 - OCL (output)
  BitWrPortI(PBDDR,&PBDDRShadow,1,4);
  // PB5 - STR (output)
  BitWrPortI(PBDDR,&PBDDRShadow,1,5);
  // PB7 - ODA (output)
  BitWrPortI(PBDDR,&PBDDRShadow,1,7);

  // Port C
  // PC0-PC1 - Seriale D
  BitWrPortI(PCFR, &PCFRShadow, 1,0);

  // PC2-PC3 - Seriale C
  // Modem GSM
  BitWrPortI(PCFR, &PCFRShadow, 1,2);

  // Port D
  // PD4-PD5 - Seriale B
  BitWrPortI(PDFR,&PDFRShadow,1,4);
  BitWrPortI(PDDDR,&PDDDRShadow,1,4);
  
  // Port E
  WrPortI(PEFR, &PEFRShadow, 0x00);
  // PE0 - DCD Modem GSM (ingresso)
  // PE1 - Pulsante esterno (ingresso)
  // PE4 - GSM Power Control (ingresso)
  // PE5 - RS485 Data Direction / RS232 DTR (output)
  BitWrPortI(PEDDR, &PEDDRShadow, 1,5);
  // PE7 - GSM On/Off (output)
  BitWrPortI(PEDDR, &PEDDRShadow, 1,7);

  // Port F
  WrPortI(PFFR, &PFFRShadow, 0x00);
  WrPortI(PFDCR, &PFDCRShadow, 0x00);
  // PF0 - Led LD3 (output)
  BitWrPortI(PFDDR, &PFDDRShadow, 1,0);
  // PF1 - Led LD1 (output)
  BitWrPortI(PFDDR, &PFDDRShadow, 1,1);
  // PF4 - Led LD2 (output)
  BitWrPortI(PFDDR, &PFDDRShadow, 1,4);
  // PF5 - Modem Reset (output)
  BitWrPortI(PFDDR, &PFDDRShadow, 1,5);
  // PF6 - SH71 External I2c (bid)
  // PF7 - SH71 External I2c (bid)

  // Port G
  WrPortI(PGFR, &PGFRShadow, 0x00);
  // PG6-PG7 - Seriale E (RF Transmitter, Caller Id, GPS Receiver)
  BitWrPortI(PGFR, &PGFRShadow, 1,6);
  BitWrPortI(PGDDR, &PGDDRShadow, 0,7);
  BitWrPortI(PGDDR, &PGDDRShadow, 1,6);

}


//-----------------------------------------------------------------
// Invia un comando alla scheda SX13
// Riceve       : cmd - comando da inviare
//                address - indirizzo di destinazione
//                dato - Dato del comando
// Restituisce  : -
//-----------------------------------------------------------------
void SendDimCommand(char cmd, char address, char dato) {
 
    printf ("Invio del comando [%c] in corso...\n",cmd);    
    serBputc(cmd);
    
    printf("Invio dell'indirizzo [%d] in corso...\n",address);
    serBputc(address);
    
    printf("Invio del dato [%d] in corso...\n",dato);
    serBputc(dato);
    
    // Invia il raddoppio del dato
    serBputc(dato);
  
  
}



// -----------------------------------------------------------------------
// -----------------------------------------------------------------------
//                               MAIN
// -----------------------------------------------------------------------
// -----------------------------------------------------------------------
main () {

  int val,i;
  char ch,addr,data;
  char	st[256];
  
  // Apertura della porta seriale con parametri 4800,N,8,1
  serBopen(4800);
  
  data=0;
  addr=1;

  while (1) {
  
    printf ("Funzione desiderata: 1 - Invio comandi diretto, 2 - Generazione Rampa (premere il numero desiderato + Invio)\n");
    gets(st);      
    val=atoi(st);
    ch=0;
    
    switch (val) {
      
    case 1:
    
      while (ch!=0x71) {
          
        printf ("Comando da inviare 1 - SET ADDRESS, 2 - SET DIMMER (premere il numero desiderato + Invio)\n");
        gets(st);
      
        val=atoi(st);
        
        switch (val) {
        
        case 1:
          
          printf (" ---> Comando scelto: Impostazione Indirizzo\n");
          
          printf ("Inserisci l'indirizzo di destinazione del comando (in decimale + Invio)\n");
          gets(st);      
          val=atoi(st);
          val &= 0xFF;
          
          addr=(char)val;      
          
          printf ("Inserisci il nuovo indirizzo da impostare (in decimale + Invio)\n");
          gets(st);
          val=atoi(st);
          val &= 0xFF;
          
          data=(char)val;
        
          SendDimCommand(SET_ADDRESS,addr,data);
          
          break;
              
        case 2:
        
          printf (" ---> Comando scelto: Impostazione Livello Dimmer\n");
        
          printf ("Inserisci l'indirizzo di destinazione  del comando (in decimale + Invio)\n");
          gets(st);      
          val=atoi(st);
          val &= 0xFF;
          
          addr=(char)val;      
          
          printf ("Inserisci il valore di luminosit (in decimale + Invio)\n");
          gets(st);
          val=atoi(st);
          val &= 0xFF;
          
          data=(char)val;
        
          SendDimCommand(SET_DIMMER,addr,data);
        
          break;
        
        default:
          printf ("Comando Sconosciuto\n");
          break;  
          
        }      
       
        printf ("Premere 'q' per terminare. Qualsiasi altro carattere per continuare\n");
        ch=getchar(); 
        
      } 
    
      break;  
  
    case 2:
  
      while (ch!=0x71) {
        
        // Rampa
        addr=0xFF;
        for (i=0;i<=255;i++) {
          
          data=(char)i;
          
          SendDimCommand(SET_DIMMER,addr,data);
          
          msDelay(50);
          
        }
    
        for (i=255;i>=0;i--) {
          
          data=(char)i;
          SendDimCommand(SET_DIMMER,addr,data);
          msDelay(50);
          
        }
        
        
        printf ("Premere 'q' per terminare. Qualsiasi altro carattere per continuare\n");
        ch=getchar();
        
      }
    
      break;  
  
    default:
    
      break;  
      
    }
  
  
  }

}